
option autorun on
rtc gettime
cls
option explicit
dim b,x,y,y2,yold,speed,sampspeed,vaxis,haxis,grid_flag,ch1,scalefactor,offset_value,data_scale_value,low_data_scale_value,initial_backlight,input_gain
dim gain,dtlocation,dtvert,tmvert,hold_vert,hold_hor,savedata_vert,savedata_hor,hold_flag,hold_value,save_flag,cb_size
dim st(810)                      'array for input values
dim st1(810)                     'array for smoothed input values that are displayed on screen and also saved to data file on SD card if enabled
dim filename_pt1$,filename_pt2$,ext$,full_file_name$,dtime$,stime$,gainsw$,space$

              'These variables used for peak detect sub routine
dim xp,yp,trigger_value,pk(100),position(100),temp_value,sample_time,peak_spacing(100),peak_spacing_ave,bpm

trigger_value=2                'find peaks over set value, eg 2 volts
xp=0                            'xp and yp are used as peak loop counters
yp=1



filename_pt1$="ECG"             'Define known parts of file name
space$=" "
ext$=".txt"


hold_value = 10                 'delay in ms for hold loop routine

ch1=77                          'Analog input pin
input_gain=51                    'Digital gain input

setpin ch1, ain                  'set pin 77 as analog input for MM100

scalefactor=((100)*-1)           'Used to scale trace on screen

'co-ordinates for hold and save check box's and file number display

hold_vert = 10
hold_hor = 520
savedata_vert = 10
savedata_hor = 630
cb_size = 35

offset_value=1                  'Value to offset base level of data - subtracted from raw data
data_scale_value=2.5            'Value to increase dynamic range of data after offset applied for high or low gain setting
low_data_scale_value=3

tmvert = 12                    'Time vertical location
dtvert = 38                    'Date vertical location
dtlocation = 425               'Date and time screen position
speed =4                       'Initial display speed
sampspeed =4                   'Initial Sample speed
initial_backlight = 50         'initial display brightness 50%
gain=0

setpin input_gain, intb, gainswitch     'set pin 51 as digital input for gain display

gainswitch                      'Determine initial gain switch setting


' reference numbers for the controls are defined as constants
Const c_bright = 1, sb_bright = 2, c_timebase=3, sb_timebase=4, c_head=5, cb_grid=6, c_samplespeed=7, sb_samplespeed=8, cb_hold=9, cb_savedata=10

colour rgb(yellow),rgb(black)

gui interrupt touchdown
 
screen_setup                      'Initial screen setup

'Main Programme Loop here

do

text 2,20,"                           ",l,2,1,rgb(black)
text 2,10,"ECG Analog Input Sampling",l,2,1,rgb(green)
CIRCLE 330, 20, 10 , , , , rgb(red)

datastore
data_offset
Data_smooth
screen_refresh
displaytrace

loop


sub screen_refresh

box 0,45,800,375,0,rgb(black),rgb(black)
'text 2,20,"                           ",l,2,1,rgb(black)
'text 2,10,"ECG Analog Input Sampling",l,2,1,rgb(green)
'CIRCLE 330, 20, 10 , , , , rgb(red)
text dtlocation,tmvert,"          ",cm,2,1,rgb(black)
text dtlocation,dtvert,"          ",cm,2,1,rgb(black)
text dtlocation,tmvert,time$,cm,2,1,rgb(yellow)
text dtlocation,dtvert,date$,cm,2,1,rgb(yellow)        'restore screen values
text 65,mm.vres*0.94,"S "+stime$+" Ms",cm,2,1,rgb(green)        'restore screen values
text 65,mm.vres*0.98,"            ",cm,2,1,rgb(black)        'restore screen values

text 65,mm.vres*0.98,"D "+dtime$+" Ms",cm,2,1,rgb(green)        'restore screen values
text dtlocation,tmvert,"          ",cm,2,1,rgb(black)
text dtlocation,dtvert,"          ",cm,2,1,rgb(black)
text dtlocation,tmvert,time$,cm,2,1,rgb(yellow)
text dtlocation,dtvert,date$,cm,2,1,rgb(yellow)         'refresh date and time after each trace
if grid_flag=1 then                          'if grid enabled refresh after each trace
gridon
endif


end sub

sub screen_setup
'define and place screen layout and controls
text 2,10,"ECG Analog Input ",l,2,1,rgb(green)
text dtlocation,tmvert,time$,cm,2,1,rgb(yellow)
text dtlocation,dtvert,date$,cm,2,1,rgb(yellow)


GUI Checkbox cb_hold, "Hold",hold_hor,hold_vert,cb_size,RGB(200,200,255)
GUI Checkbox cb_savedata, "Save Data",savedata_hor,savedata_vert,cb_size,RGB(200,200,255)

GUI Checkbox cb_grid, "Grid",140,445,30,RGB(200,200,255)

GUI Caption c_samplespeed, "S Delay", 230, 450,,RGB(200,200,255),0
GUI Spinbox sb_samplespeed, MM.HPos + 4, 440, 110, 30,RGB(yellow),,1, 2, 8
CtrlVal(sb_samplespeed) = sampspeed

GUI Caption c_bright, "Bright", 610, 450,,RGB(200,200,255),0
GUI Spinbox sb_bright, MM.HPos + 4, 440, 110, 30,RGB(green),,10, 10, 100
CtrlVal(sb_bright) = initial_backlight

GUI Caption c_timebase, "Dis Delay", 410, 450,,RGB(200,200,255),0
GUI Spinbox sb_timebase, MM.HPos + 4, 440, 110, 30,RGB(yellow),,1, 0, 20
CtrlVal(sb_timebase) = speed

text 65,mm.vres*0.94,"            ",cm,2,1,rgb(black)        'restore screen values
text 65,mm.vres*0.94,"S "+stime$+" Ms",cm,2,1,rgb(green)        'restore screen values
text 65,mm.vres*0.98,"            ",cm,2,1,rgb(black)        'restore screen values
text 65,mm.vres*0.98,"D "+dtime$+" Ms",cm,2,1,rgb(green)        'restore screen values

text dtlocation,tmvert,"          ",cm,2,1,rgb(black)
text dtlocation,dtvert,"          ",cm,2,1,rgb(black)
text dtlocation,tmvert,time$,cm,2,1,rgb(yellow)
text dtlocation,dtvert,date$,cm,2,1,rgb(yellow)         'refresh date and time after each trace
if grid_flag=1 then                                     'if grid enabled refresh after each trace
gridon
endif
end sub

sub datastore
timer=0
for x=0 to 800                                   'x=0 prevents false level at start of trace

  st(x)=pin(ch1)                                 'store new value 
  
 pause (sampspeed)                              'Sample delay
next x
stime$=str$(timer)                              'used for display of elapsed sample time
sample_time=timer                               'used in claculation of peak spacing in Msec

screen_restore_values

end sub

sub displaytrace
text 2,10,"                           ",cm,2,1,rgb(black)
text 2,10,"ECG Analog Input  Display",l,2,1,rgb(green)
CIRCLE 330, 20, 10 , , , , rgb(green)
timer=0
for x=1 to 799                                'x=799 prevents false level at end of trace 

  y=st1(x)*(scalefactor)+400                  'Get new pixel value
  y2=st1(x+1)*(scalefactor)+400               'Get next pixel value
  
  if y<50 then                                'Test for out of display area
  y=50
  endif
  if y2<50 then
  y2=50
  endif
  if y>415 then
  y=415
  endif
  if y2>415 then
  y2=415
  endif
  
  
  line x,y,x+1,y2,,rgb(yellow)               'draw line between consecutive values on display
  pause (speed)                              'trace delay
next x
dtime$=str$(timer)

screen_restore_values

peak_detect
text 350,375,"          ",l,3,1,rgb(black)
text 350,375,"PPM  "+str$(bpm),l,3,1,rgb(green)


do while hold_flag=1
holddelay
loop

if save_flag=1 then
save_data_file
save_flag=0
Ctrlval(cb_savedata)=0
end if

end sub



' the interrupt routine for touch down
' using a select case command it has a different process for each control

sub touchdown
Select Case Touch(REF) ' find out the control touched
Case sb_bright ' the brightness spin box
BackLight CtrlVal(sb_bright)
case sb_timebase  ' the speed spin box
speed = CtrlVal(sb_timebase)
case sb_samplespeed  ' the speed spin box
sampspeed = CtrlVal(sb_samplespeed)
case cb_grid
if CtrlVal(cb_grid) then 
gridon
grid_flag=1
else 
gridoff
grid_flag=0
endif

case cb_hold
if CtrlVal(cb_hold) then
hold_flag=1
else
hold_flag=0
endif

'insert case for data save routine here
case cb_savedata
if Ctrlval(cb_savedata) then
save_flag=1
else
save_flag=0
endif


End Select
end sub




sub Gridon                                   'sub routine to draw grid

for vaxis=0 to 800 step 80
line vaxis,75,vaxis,405,1,rgb(96,96,96)      'draw vertical grid lines
next vaxis

for haxis=75 to 405 step 33
line 0,haxis,800,haxis,1,rgb(96,96,96)        'draw horizontal grid lines
next haxis


end sub

sub Gridoff                                   'sub routine to clear grid

for vaxis=0 to 800 step 80 
line vaxis,75,vaxis,405,1,rgb(black)          'clear vertical grid lines
next vaxis

for haxis=75 to 405 step 33
line 0,haxis,800,haxis,1,rgb(black)          'clear horizontal grid lines
next haxis

end sub

'The interrupt routine for Gain switch in ECG unit
sub gainswitch
gain=pin(input_gain)
if gain=1 then                          'Determine if gain switch in high or low setting and display accordingly
gainsw$="High"
else
gainsw$="Low"
endif
text 1,mm.vres*0.88,"                          ",l,2,1,rgb(green)
text 1,mm.vres*0.88,"ECG I/P Gain "+gainsw$,l,2,1,rgb(green)

end sub

sub holddelay
pause hold_value

end sub

sub save_data_file

filename_pt2$=left$(time$,2)+"-"+mid$(time$,4,2)+"-"+right$(time$,2)
full_file_name$=filename_pt1$+space$+date$+space$+filename_pt2$+ext$

open full_file_name$ for output as #2
print #2,full_file_name$
for x=1 to 799
print #2, st1(x)
next x
close #2


end sub

sub screen_restore_values

text 65,mm.vres*0.94,"            ",cm,2,1,rgb(black)        'restore screen values
text 65,mm.vres*0.94,"S "+stime$+" Ms",cm,2,1,rgb(green)        'restore screen values
text 65,mm.vres*0.98,"            ",cm,2,1,rgb(black)        'restore screen values
text 65,mm.vres*0.98,"D "+dtime$+" Ms",cm,2,1,rgb(green)        'restore screen values

end sub

sub peak_detect
temp_value=0
bpm=0
yp=1
for xp=1 to 799

if st1(xp) >trigger_value then
temp_value=st1(xp)

  if st1(xp+1)>temp_value then
  temp_value=st1(xp+1)
  pk(yp)=temp_value
  position(yp) = xp+1
  else
  
  if st1(xp+1) < trigger_value then
  yp=yp+1
  endif
  
  next xp
  endif
  
endif
if xp<799 then
next xp
endif

                'Next section shows peak position, value, spacing and spacing time in Ms, also stores spacing in array peak_spacing
                'Values are printed to terminal for testing
if yp>2 then
for xp=1 to yp-1
print "Peak Position ",position(xp)," Value  ",pk(xp)
    if pk(xp+1)>0 then
print "Spacing ",position(xp+1)-position(xp)," =",(position(xp+1)-position(xp))*(sample_time/800),"Msec"
peak_spacing(xp)=position(xp+1)-position(xp)


    endif
next xp

              'Next section calculates average spacing and claculates average peaks per minute as ppm.
              'Values are printed to terminal for testing

if yp>2 then
temp_value=0

for xp=1 to yp-2
temp_value=temp_value+peak_spacing(xp)
next xp
peak_spacing_ave=temp_value/(yp-2)
if peak_spacing_ave>0 then
bpm=fix((60/(peak_spacing_ave*(sample_time/800)))*1000)
print "peak spacing average is  ",peak_spacing_ave,"  Peaks per minute =",bpm
print

endif

endif

print
else
print " No valid Peak detected"
endif
end sub

sub data_offset
for x=1 to 800
st(x)=st(x)-offset_value
if gain=1 then
st(x)=st(x)*data_scale_value
else
st(x)=st(x)*low_data_scale_value
endif
next x
end sub


sub Data_smooth                             'Apply 4 period simple moving average to array st1 using data from array st
for x=1 to 4
st1(x)=st(x)
next x

for x=4 to 800
st1(x)=((st(x-1)+st(x-2)+st(x-3)+st(x-4))/4)
next x

end sub
